/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.queue;

import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketAttributesPanel;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketColumnPanel;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketFilterPanel;
import filenet.vw.toolkit.admin.property.queue.VWWorkBasketQueueQueryPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.images.VWToolbarButtonFocusAdapter;
import filenet.vw.toolkit.utils.uicontrols.border.VWInfoLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWWorkBasketPropertyPanel
extends JPanel
implements ActionListener,
DocumentListener {
    private VWSessionInfo m_sessionInfo = null;
    private VWWorkBasketDefinition m_workBasketDef = null;
    private boolean m_bIsModified = false;
    private JLabel m_workBasketNameLabel = null;
    private JButton m_helpButton = null;
    private JTextArea m_descriptionTextArea = null;
    private JTabbedPane m_tabbedPane = null;
    private VWWorkBasketColumnPanel m_workBasketColumnPanel = null;
    private VWWorkBasketFilterPanel m_workBasketFilterPanel = null;
    private VWWorkBasketQueueQueryPanel m_queueQueryPanel = null;
    private VWWorkBasketAttributesPanel m_attributesPanel = null;

    public VWWorkBasketPropertyPanel(VWSessionInfo sessionInfo, boolean bDisplayIndexControls) {
        this.m_sessionInfo = sessionInfo;
        this.createControls(bDisplayIndexControls);
        this.setEnabled(false);
    }

    public void setEnabled(boolean bEnabled) {
        this.m_workBasketNameLabel.setEnabled(bEnabled);
        this.m_descriptionTextArea.setEnabled(bEnabled);
        this.m_workBasketColumnPanel.setEnabled(bEnabled);
        this.m_workBasketFilterPanel.setEnabled(bEnabled);
        this.m_queueQueryPanel.setEnabled(bEnabled);
        this.m_attributesPanel.setEnabled(bEnabled);
    }

    public void checkForErrors() throws Exception {
        if (this.m_workBasketColumnPanel != null) {
            this.m_workBasketColumnPanel.checkForErrors();
        }
        if (this.m_workBasketFilterPanel != null) {
            this.m_workBasketFilterPanel.checkForErrors();
        }
        if (this.m_queueQueryPanel != null) {
            this.m_queueQueryPanel.checkForErrors();
        }
        if (this.m_attributesPanel != null) {
            this.m_attributesPanel.checkForErrors();
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.stopEditing();
        if (event.getSource().equals(this.m_helpButton)) {
            String helpPage = VWHelp.Help_Process_Config + "bpfc096.htm";
            if (this.m_tabbedPane != null) {
                switch (this.m_tabbedPane.getSelectedIndex()) {
                    case 0: {
                        helpPage = helpPage.concat("#columns");
                        break;
                    }
                    case 1: {
                        helpPage = helpPage.concat("#filters");
                        break;
                    }
                    case 2: {
                        helpPage = helpPage.concat("#content");
                    }
                }
            }
            VWHelp.displayPage(helpPage);
        }
    }

    public void changedUpdate(DocumentEvent event) {
        this.handleUpdateEvent(event.getDocument());
    }

    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWorkBasketDefinition(VWWorkBasketDefinition workBasketDef) {
        try {
            try {
                this.m_workBasketDef = workBasketDef;
                this.setEnabled(workBasketDef != null);
                this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
                if (this.m_workBasketDef != null) {
                    this.m_workBasketNameLabel.setText(this.m_workBasketDef.getName());
                    VWAccessibilityHelper.setAccessibility(this.m_workBasketNameLabel, this, this.m_workBasketNameLabel.getText(), this.m_workBasketNameLabel.getText());
                    this.m_descriptionTextArea.setText(this.m_workBasketDef.getDescription());
                    this.m_descriptionTextArea.setCaretPosition(0);
                } else {
                    this.m_workBasketNameLabel.setText(VWResource.NoInbasketSelected);
                    VWAccessibilityHelper.setAccessibility(this.m_workBasketNameLabel, this, this.m_workBasketNameLabel.getText(), this.m_workBasketNameLabel.getText());
                    this.m_descriptionTextArea.setText(null);
                }
                this.m_workBasketColumnPanel.setWorkBasketDefinition(workBasketDef);
                this.m_workBasketFilterPanel.setWorkBasketDefinition(workBasketDef);
                this.m_queueQueryPanel.setWorkBasketDefinition(workBasketDef);
                this.m_attributesPanel.setWorkBasketDefinition(workBasketDef);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var4_3 = null;
                this.m_descriptionTextArea.getDocument().addDocumentListener(this);
                this.m_bIsModified = false;
            }
            Object var4_2 = null;
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_bIsModified = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            this.m_bIsModified = false;
            throw throwable;
        }
    }

    protected void setQueueDefinition(VWQueueDefinition queueDef) {
        if (this.m_workBasketColumnPanel != null) {
            this.m_workBasketColumnPanel.setQueueDefinition(queueDef);
        }
        if (this.m_workBasketFilterPanel != null) {
            this.m_workBasketFilterPanel.setQueueDefinition(queueDef);
        }
        if (this.m_queueQueryPanel != null) {
            this.m_queueQueryPanel.setQueueDefinition(queueDef);
        }
        if (this.m_attributesPanel != null) {
            this.m_attributesPanel.setQueueDefinition(queueDef);
        }
    }

    protected boolean isModified() {
        if (this.m_workBasketColumnPanel.isModified()) {
            return true;
        }
        if (this.m_workBasketFilterPanel.isModified()) {
            return true;
        }
        if (this.m_queueQueryPanel.isModified()) {
            return true;
        }
        if (this.m_attributesPanel.isModified()) {
            return true;
        }
        return this.m_bIsModified;
    }

    protected void resetModifiedFlag() {
        if (this.m_workBasketColumnPanel != null) {
            this.m_workBasketColumnPanel.resetModifiedFlag();
        }
        if (this.m_workBasketFilterPanel != null) {
            this.m_workBasketFilterPanel.resetModifiedFlag();
        }
        if (this.m_queueQueryPanel != null) {
            this.m_queueQueryPanel.resetModifiedFlag();
        }
        if (this.m_attributesPanel != null) {
            this.m_attributesPanel.resetModifiedFlag();
        }
        this.m_bIsModified = false;
    }

    protected void stopEditing() {
    }

    protected void releaseResources() {
        this.m_workBasketNameLabel = null;
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.getDocument().removeDocumentListener(this);
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        if (this.m_workBasketColumnPanel != null) {
            this.m_workBasketColumnPanel.releaseResources();
            this.m_workBasketColumnPanel = null;
        }
        if (this.m_workBasketFilterPanel != null) {
            this.m_workBasketFilterPanel.releaseResources();
            this.m_workBasketFilterPanel = null;
        }
        if (this.m_queueQueryPanel != null) {
            this.m_queueQueryPanel.releaseResources();
            this.m_queueQueryPanel = null;
        }
        if (this.m_attributesPanel != null) {
            this.m_attributesPanel.releaseResources();
            this.m_attributesPanel = null;
        }
        this.m_sessionInfo = null;
        this.m_workBasketDef = null;
        this.removeAll();
    }

    private void createControls(boolean bDisplayIndexControls) {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(10, 10, 5, 10);
            gbCons.gridheight = 1;
            gbCons.gridwidth = -1;
            this.m_workBasketNameLabel = new JLabel(VWResource.NoInbasketSelected);
            VWAccessibilityHelper.setAccessibility(this.m_workBasketNameLabel, this, VWResource.Name, VWResource.Name);
            this.add((Component)this.m_workBasketNameLabel, gbCons);
            gbCons.anchor = 22;
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.gridwidth = 0;
            this.m_helpButton = (JButton)VWImageLoader.createToolBarButton("help20.gif", VWResource.Help, false);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.Help, VWResource.Help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_helpButton.getAccessibleContext().setAccessibleName(VWResource.Help);
            this.m_helpButton.addFocusListener(new VWToolbarButtonFocusAdapter(this.m_helpButton));
            this.m_helpButton.setRolloverEnabled(true);
            this.m_helpButton.setFocusable(true);
            this.m_helpButton.setBorderPainted(false);
            this.add((Component)this.m_helpButton, gbCons);
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 0.4;
            gbCons.weighty = 0.2;
            gbCons.gridwidth = -1;
            this.add((Component)this.getDescriptionPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.weightx = 0.6;
            gbCons.gridwidth = 0;
            this.add((Component)new JLabel(" "), gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.8;
            this.m_tabbedPane = new JTabbedPane();
            this.m_workBasketColumnPanel = new VWWorkBasketColumnPanel(this.m_sessionInfo, bDisplayIndexControls);
            this.m_workBasketColumnPanel.getAccessibleContext().setAccessibleParent(this.m_tabbedPane);
            VWAccessibilityHelper.setAccessibility(this.m_workBasketColumnPanel, this.m_tabbedPane, VWResource.CreateColumnsAndLabels, VWResource.CreateColumnsAndLabels);
            this.m_workBasketColumnPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPane.add(VWResource.CreateColumnsAndLabels, this.m_workBasketColumnPanel);
            this.m_workBasketFilterPanel = new VWWorkBasketFilterPanel(this.m_sessionInfo);
            this.m_workBasketFilterPanel.getAccessibleContext().setAccessibleParent(this.m_tabbedPane);
            VWAccessibilityHelper.setAccessibility(this.m_workBasketFilterPanel, this.m_tabbedPane, VWResource.CreateFilters, VWResource.CreateFilters);
            this.m_workBasketFilterPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPane.add(VWResource.CreateFilters, this.m_workBasketFilterPanel);
            this.m_queueQueryPanel = new VWWorkBasketQueueQueryPanel(this.m_sessionInfo, bDisplayIndexControls);
            this.m_queueQueryPanel.getAccessibleContext().setAccessibleParent(this.m_tabbedPane);
            VWAccessibilityHelper.setAccessibility(this.m_queueQueryPanel, this.m_tabbedPane, VWResource.DefineContent, VWResource.DefineContent);
            this.m_queueQueryPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPane.add(VWResource.DefineContent, this.m_queueQueryPanel);
            this.m_attributesPanel = new VWWorkBasketAttributesPanel(this.m_sessionInfo);
            this.m_attributesPanel.getAccessibleContext().setAccessibleParent(this.m_tabbedPane);
            VWAccessibilityHelper.setAccessibility(this.m_attributesPanel, this.m_tabbedPane, this.m_attributesPanel.getTitle(), this.m_attributesPanel.getTitle());
            this.m_attributesPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPane.add(this.m_attributesPanel.getTitle(), this.m_attributesPanel);
            this.add((Component)this.m_tabbedPane, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getDescriptionPanel() {
        try {
            JPanel descriptionPanel = new JPanel(new BorderLayout(3, 3));
            VWInfoLabel descriptionLabel = new VWInfoLabel(VWResource.Description);
            descriptionLabel.updateFontSize("10");
            VWAccessibilityHelper.setAccessibility(descriptionLabel, this, VWResource.Description, VWResource.Description);
            descriptionPanel.add((Component)descriptionLabel, "First");
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(5);
            this.m_descriptionTextArea.getDocument().addDocumentListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_descriptionTextArea, this, VWResource.Description, VWResource.Description);
            VWAccessibilityHelper.setLabelFor(new JLabel(VWResource.Description), this.m_descriptionTextArea);
            descriptionPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            return descriptionPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void handleUpdateEvent(Object source) {
        if (this.m_workBasketDef == null || source == null) {
            return;
        }
        if (source.equals(this.m_descriptionTextArea.getDocument())) {
            try {
                if (VWStringUtils.compare(this.m_workBasketDef.getDescription(), this.m_descriptionTextArea.getText()) != 0) {
                    this.m_workBasketDef.setDescription(this.m_descriptionTextArea.getText());
                    this.m_bIsModified = true;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_sessionInfo.getParentFrame(), ex.getLocalizedMessage(), 1);
                this.m_descriptionTextArea.selectAll();
            }
        }
    }
}

